(function($) {

    "use strict";

    $(document).ready(function() {

        

        if (!$('.codeless-player-mejs').length) {
            return;
        }

        if ( !$('.codeless-player-mejs').hasClass('codeless-player-void-player') ) {
           window.codeless_player_detect_audio($('body'));
       }

       

        /* Toggle the player */

        $('body').on('click', '.codeless-player-toggle', function(e) {
            e.preventDefault();
            $('.codeless-player').toggleClass('codeless-player-collapsed');
        });

         /* Hide volume button on mobile devices */
        var isMobile = /iPhone|iPad|iPod|Android/i.test(navigator.userAgent);
        if (isMobile) {
           $('.codeless-player .mejs-volume-button').hide();
        }

    });


    


    window.codeless_player_detect_audio = function(container) {

        window.codeless_player_status = '';

        /* Detect first playable source and initialize the player */
        $.each(codeless_player_settings.selectors, function(selector, item) {
           
            if (!container.find(selector).length) {
                return;
            }

            var source = '';

            if (selector == 'iframe') {

                // var elements_to_check = Array.from( item.match );
                // elements_to_check = elements_to_check.join( ',' );
                var type = '';

                item.match.forEach(function(element, item){
                    var found = container.find( element );
                    if ( found.length ) {
                        source = found;
                        type = element;
                        return;
                    }
                    return;
                })

                if ( source == '' || source == undefined ) {
                    return
                }

                source = source.first();
                
                type = type.match(/'(.*\.)/);
                if ( type != null ) {
                    item.type = type[1].slice( 0, (type[1].length - 1) );
                }

                item.type += ' custom';

            } else {

                if (item.element == 'self') {
                    source = container.find(selector).first();
                } else {
                    source = container.find(selector).first().hide().find(item.element);
                }
            }


            if (item.type == 'audio') {
                window.codeless_player_status = 'audio';
            } else if (item.type == 'custom') {
                window.codeless_player_status = 'custom';
            } else {
               window.codeless_player_status = item.type;
            }

            window.codeless_player_init(source);

            return false;

        });


    };


    window.codeless_player_init = function(source) {

        source.appendTo('.codeless-player-mejs').attr('id', 'codeless-player-source').attr('preload', 'auto').attr('width', '').attr('height', '').removeClass();

        var player = '';

        if ($('.codeless-player-mejs audio').length) {

            player = new MediaElementPlayer('codeless-player-source', {
                'classPrefix': 'mejs-',
                'isVideo': false,
                'setDimensions': false,
                'alwaysShowControls': true,
                'audioVolume': 'vertical',
                'startVolume': codeless_player_settings.player.volume,
                'skipBackInterval': 15,
                'jumpForwardInterval': 15,
                'timeAndDurationSeparator': '<span> / </span>',
                'features': Array.from(codeless_player_settings.player.controls),
                'speeds': ['2', '1.5', '1.25', '0.75'],
                'defaultSpeed': '1',
                success: function(mediaElement, originalNode, instance) {

                    mediaElement.addEventListener('ended', function(e) {
                        $(document).trigger('codeless_ap_player_ended');
                    }, false);

                    $('body').find('.mejs-playpause-button').on('click', function(){
                        $(document).trigger('codeless_ap_playpause');
                    });
                }
            });

        }

        window.codeless_player = player;


        $(".codeless-jump-to-player").on("click", function (e) {
            e.preventDefault();
            var seconds = $(this).data('position');
            player.setCurrentTime(seconds); // set starting time
            player.play(); 
        });
    };
})(jQuery);