<?php
/*
Plugin Name: Codeless Player
Description: Automatically transform audio to a Sticky Audio Player or Elementor Widget Player
Version: 1.0.2
Author: Codeless
Author URI: https://codeless.co/
Text Domain: codeless-player
Domain Path: /languages
*/

/* Prevent direct accAP */
if ( !defined( 'DB_NAME' ) ) {
	header( 'HTTP/1.0 403 Forbidden' );
	die;
}

define( 'CODELESS_PLAYER_URL', trailingslashit( plugin_dir_url( __FILE__ ) ) );
define( 'CODELESS_PLAYER_DIR', trailingslashit( plugin_dir_path( __FILE__ ) ) );
define( 'CODELESS_PLAYER_VER', '1.0.2' );
define( 'CODELESS_PLAYER_BASENAME', plugin_basename( __FILE__ ) );

/* Includes */
require_once CODELESS_PLAYER_DIR . 'inc/functions.php';
require_once CODELESS_PLAYER_DIR . 'inc/class-audio.php';

/* Start plugin */
add_action( 'init', 'codeless_player_init' );

function codeless_player_init() {
	$codeless_player = Codeless_Player::get_instance();
}