<?php

class Codeless_Player {

    /**
     *  Hold the class instance.
     */
    private static $instance = null;

    private $post_type = 'podcast';
    private $used_on_widget = false;
    /**
     * Start up
     */
    function __construct() {

        add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );

        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_frontend_scripts' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'script_compatibility' ), 99 );

        add_action( 'wp_footer', array( $this, 'display_player' ) );

    }

    public static function get_instance() {
        if ( self::$instance == null ) {
            self::$instance = new Codeless_Player();
        }
        return self::$instance;
    }

    /* Load translation file */
    function load_textdomain() {
        load_plugin_textdomain( 'codeless-player', false, dirname( CODELESS_PLAYER_BASENAME ) . '/languages' );
    }

    /**
     * Enqueue Frontend Scripts
     */
    function enqueue_frontend_scripts() {

        wp_enqueue_style( 'codeless_player-main', CODELESS_PLAYER_URL . 'assets/css/main.css', array(), CODELESS_PLAYER_VER );

        wp_enqueue_script( 'codeless_player-player', CODELESS_PLAYER_URL . 'assets/js/mediaelement-and-player.js', array( 'jquery' ), CODELESS_PLAYER_VER, true );
        wp_enqueue_script( 'codeless_player-player-skip-back', CODELESS_PLAYER_URL . 'assets/js/mediaelement-skip-back.js', array( 'jquery'), CODELESS_PLAYER_VER, true );
        wp_enqueue_script( 'codeless_player-player-jump-forward', CODELESS_PLAYER_URL . 'assets/js/mediaelement-jump-forward.js', array( 'jquery'), CODELESS_PLAYER_VER, true );
        wp_enqueue_script( 'codeless_player-player-speed', CODELESS_PLAYER_URL . 'assets/js/mediaelement-speed.js', array( 'jquery'), CODELESS_PLAYER_VER, true );

        wp_enqueue_script( 'codeless_player-main', CODELESS_PLAYER_URL . 'assets/js/main.js', array( 'jquery' ), CODELESS_PLAYER_VER, true );

        wp_localize_script( 'codeless_player-main', 'codeless_player_settings', $this->get_js_settings() );

        $inline_styles = $this->get_inline_styles();

        if ( !empty( $inline_styles ) ) {
            wp_add_inline_style( 'codeless_player-main', $inline_styles );
        }

    }

    function script_compatibility() {

        wp_deregister_script( 'mediaelement-core' );
        wp_deregister_script( 'mediaelement' );
        wp_deregister_script( 'wp-mediaelement' );
        wp_deregister_script( 'mediaelement-migrate' );

        wp_deregister_style( 'wp-mediaelement' );
        wp_deregister_style( 'mediaelement' );

    }

    function get_js_settings() {

        $settings['selectors'] = $this->get_allowed_selectors();

        $settings['player'] = array();
        $settings['player']['controls'] =  ['skipback', 'playpause', 'jumpforward', 'progress', 'current', 'duration', 'volume', 'speed'];
        $settings['player']['volume'] =  50/100;

        return $settings;
    }

    /**
     * Get inline styles (player colors)
     */
    function get_inline_styles() {
        global $codeless_online_mods;

        if( ! function_exists( 'codeless_get_mod' ) )
            return false;

        if( isset( $_GET['player_colors'] ) && $_GET['player_colors'] == 'light' ){
            $codeless_online_mods['fixed_player_bg_color'] = '#fff';
            $codeless_online_mods['fixed_player_foreground_color'] = '#040D1C';
        }

        $styles = '.codeless-player, .mejs-volume-total, .codeless-player-collapsed .codeless-player-toggle {
                    background: ' . codeless_get_mod( 'fixed_player_bg_color', '#000' ) . ';
                 }';

        $styles .= '.codeless-player, .codeless-player a, .mejs-button>button {
                    color: ' . codeless_get_mod( 'fixed_player_foreground_color', '#fff' ) . ';
                 }';

        $styles .= '.mejs-volume-button>.mejs-volume-slider,.mejs__speed-selector, .mejs-speed-selector, .mejs-playpause-button {
                    background-color: '. codeless_get_mod( 'fixed_player_foreground_color', '#fff' ) .';
                }';

        $styles .= '.mejs-volume-button:hover > button:before,.mejs__speed-selector,.mejs-speed-selector, .mejs-speed-button:hover button, .mejs-playpause-button button{
                    color: '. codeless_get_mod( 'fixed_player_bg_color', '#000' ) .';
                }';
        $styles .= '.mejs-time-current, .mejs-time-handle-content{
                    background-color: '. codeless_get_mod( 'fixed_player_accent_color', '#00a7d1' ) .';
            }';
        $styles .= '.codeless-player .codeless-player-category a{
                    color: '.codeless_get_mod( 'fixed_player_accent_color', '#00a7d1' ).';
            }';
        $styles .= '.mejs-time-handle-content{
                border-color: '. codeless_get_mod( 'fixed_player_foreground_color', '#fff' ) .';
        }';

        $styles .= ':root{
            --player-original-bg-color: ' . codeless_get_mod( 'fixed_player_bg_color', '#000' ) . ';
        }';
        return $styles;
    }

   

    function get_allowed_blocks() {

        return apply_filters( 'codeless_player_modify_allowed_blocks', array( 'core/audio' ) );

    }

    function get_allowed_shortcodes() {

        return apply_filters( 'codeless_player_modify_allowed_shortcodes', array( 'audio', 'powerpress', 'ss_player' ) );

    }

    public function get_allowed_selectors() {

        $selectors = array(
            '.wp-block-audio' => array( 'element' => 'audio', 'type' => 'audio'),
            '.wp-audio-shortcode' => array( 'element' => 'self', 'type' => 'audio'),
            '.powerpress_player' => array( 'element' => 'audio', 'type' => 'audio'),
            '.powerpress_links' => array( 'element' => 'audio', 'type' => 'audio')
        );

        return apply_filters( 'codeless_player_modify_allowed_selectors', $selectors );

    }

    /**
     * Function which checks if we should display the player on the current page
     */
    function is_playable() {

        if ( !function_exists( 'parse_blocks' ) ) {
            //WP 5.0+ only
            return false;
        }

        if ( !is_singular( $this->post_type ) ) {
            return false;
        }

        $content = get_the_content( get_queried_object_id() );

        //print_r( $content );

        $blocks = parse_blocks( $content );

        if ( empty( $blocks ) ) {
            return false;
        }

        $allowed_blocks = $this->get_allowed_blocks();

        foreach ( $blocks as $block ) {

            //print_r( $block );

            if ( in_array( $block['blockName'], $allowed_blocks ) ) {
                return true;
            }
        }

        $allowed_shortcodes = $this->get_allowed_shortcodes();

        foreach ( $allowed_shortcodes as $shortcode ) {

            if ( has_shortcode( $content, $shortcode ) ) {
                return true;
            }

        }


        return false;
    }

    /**
     * Player template
     */
    public function get_player_template_path() {

        return apply_filters( 'codeless_player_modify_player_template_path',  CODELESS_PLAYER_DIR . 'inc/player.php' );

    }


    /**
     * Display the player
     */
    function display_player() {

        if ( (!$this->is_playable() && !is_page() ) ) { 
            return;
        }
        $options = array(
            'is_widget' => false,
            'colors' => 'dark',
            'style' => 'default'
        );

        if( isset( $_GET['player_colors'] ) && $_GET['player_colors'] == 'light' )
            $options['colors'] = 'light';

        include_once $this->get_player_template_path();

    }

    function display_player_widget( $options = array() ) {
        include_once $this->get_player_template_path();
        $this->used_on_widgets = true;
    }

}
