<?php


if ( ! function_exists( 'codeless_player_esc_text' ) ) :
	function codeless_player_esc_text( $text ) {
		return rawurlencode( html_entity_decode( wp_kses( $text, null ), ENT_COMPAT, 'UTF-8' ) );
	}
endif;


if ( ! function_exists( 'codeless_player_post_types' ) ) :
	function codeless_player_post_types() {

		$args = array(
			'public' => true,
		);

		$post_types = get_post_types( $args, 'objects' );

		if ( ! empty( $post_types ) ) {

			$exclude = array( 'attachment', 'topic', 'forum', 'guest-author', 'reply' );

			foreach ( $post_types as $key => $post_type ) {
				if ( in_array( $key, $exclude ) ) {
					unset( $post_types[ $key ] );
				}
			}
		}

		$post_types = apply_filters( 'codeless_player_modify_post_types_list', $post_types );

		return $post_types;
	}
endif;


if ( ! function_exists( 'codeless_player_parse_args' ) ) :
	function codeless_player_parse_args( &$a, $b ) {

		$a = (array) $a;
		$b = (array) $b;
		$r = $b;
		foreach ( $a as $k => &$v ) {
			if ( is_array( $v ) && ! isset( $v[0] ) && isset( $r[ $k ] ) ) {
				$r[ $k ] = codeless_player_parse_args( $v, $r[ $k ] );
			} else {
				$r[ $k ] = $v;
			}
		}

		return $r;
	}
endif;



if (!function_exists('codeless_player_log')):
    function codeless_player_log($mixed) {

        if (is_array($mixed)) {
            $mixed = print_r($mixed, 1);
        } else if (is_object($mixed)) {
            ob_start();
            var_dump($mixed);
            $mixed = ob_get_clean();
        }

        $handle = fopen( plugin_dir_path( __FILE__ ) . 'log', 'a');
        fwrite($handle, $mixed . PHP_EOL);
        fclose($handle);
    }
endif;
